﻿using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using System.Web;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DataExportContactLog : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (UserSession.IsRegistryAdministrator)
            {
                Response.ClearContent();
                Response.AddHeader("content-disposition", "attachment; filename=DataExport.xls");
                Response.ContentType = "application/vnd.ms-excel";
            }
            else
                Response.Redirect("~/AccessDenied.aspx", false);

            // Added for 508 compliance with GridView column headers and footer
            //Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridView1.ClientID + "');", true);
        }

        protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
            //Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
            //Use the code below to explicitely convert affected columns into text format
            //Column numbers start with 0

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Cells[0].Attributes.Add("class", "text");
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
        }

        protected void ObjectDataSource1_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            try
            {
                e.InputParameters.Clear();

                e.InputParameters.Add("CURRENT_USER", System.Web.HttpContext.Current.User.Identity.Name);
                e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}